<script type="text/javascript">
<!--

var g_root_path = "./";
var g_dateStart = null;
var g_dateEnd = null;
var g_resort = 0;
var g_room = 0;
var g_view = 0;

function addPointDate()
{
  var table = document.getElementById("PointTable");

  // add a row
  var rowCount = table.rows.length;
  var row = table.insertRow(rowCount);

  // add row cell
  var cell1 = row.insertCell(0);
  // add title box
  var element1 = document.createElement("input");
  element1.type = "text";
  element1.name = "description[]";
  // remove style, most compatable
  element1.removeAttribute("style");
  element1.style.cssText = "width:300px;";
  // append element
  cell1.appendChild(element1);
  
  // add row cell
  var cell2 = row.insertCell(1);
  // add quantity box
  var element2 = document.createElement("input");
  element2.type = "text";
  element2.name = "quantity[]";
  element2.value = "1";
  // remove style, most compatable
  element2.removeAttribute("style");
  element2.style.cssText = "width:60px;";
  // append element
  cell2.appendChild(element2);
  
  // set focus
  element1.focus();
}

function showCalendar( showadd )
{
  // get element variables
  var elementCalendar = document.getElementById("calendar");
  var elementCalendarInfo = document.getElementById("calendar_info");
  var elementPoints = document.getElementById("points");
  var elementCalculate = document.getElementById("calculate");
  if( document.getElementById("add") )
    var elementAdd = document.getElementById("add");

  // check if showing
  if( elementCalendar.style.display == "block" )
  {
    // recalc points
    calcPoints( g_dateStart, g_dateEnd );
  }
  else
  {
    // show others
    elementCalendar.style.display = "block";
    elementCalendarInfo.style.display = "block";
    elementCalculate.style.display = "block";
    if( document.getElementById("add") )
      elementAdd.style.visibility = "visible";
  }
}

function showOthers()
{
  var elementOthers = document.getElementById("show_others");
  if( elementOthers )
  {
    // get checked
    if( document.getElementById("show_others").checked == true )
      document.getElementById("td_others").style.display = "block";
    else
      document.getElementById("td_others").style.display = "none";

    // recalc points
    calcPoints( g_dateStart, g_dateEnd );
  }
}

function clearResorts()
{
  for( resort=1; resort<=15; resort++ )
  {
    for( room=1; room<=15; room++ )
    {
      for( view=1; view<=15; view++ )
      {
        // "points-" + resort + "-" + room + "-" view
        //points-7-2-2
        var elementPoints = document.getElementById( "points-" + resort + "-" + room + "-" + view );
        if( elementPoints )
            elementPoints.innerHTML = "-";
      }
    }
  }
}

function showResorts( group )
{  
  var elementHide = document.getElementById( "group-" + group );
  if( elementHide )
  {
    if( elementHide.style.display != "none" )
    {
      elementHide.style.display = "none";
    }
    else
    {
      elementHide.style.display = "";
    }
  }
}


function hideResortRow( resort )
{
  var elementHider = document.getElementById( "resort-" + resort + "-hider" );
  var elementButton = document.getElementById( "resort-" + resort + "-button" ); 
  var elementResort = document.getElementById( "resort-" + resort );
  if( elementResort )
  {
    // get hidden
    if( elementResort.style.display != "none" )
    {
      elementResort.style.display = "none";
      if( elementHider )
        elementHider.title = "Show Resort";
      if( elementButton )
        elementButton.src = "/images/show.png"
    }
    else
    {
      elementResort.style.display = "";
      if( elementHider )
        elementHider.title = "Hide Resort";
      if( elementButton )
        elementButton.src = "/images/hide.png"
    }
  }
}


function getPoints()
{
  // get dates
  try
  {
    g_dateStart = document.getElementById("date_start").value;
    g_dateEnd = document.getElementById("date_end").value;
  }
  catch(e)
  {
    return;
  }

  // recalc points
  calcPoints( g_dateStart, g_dateEnd );
}


function calcResorts( dateStart, dateEnd )
{
  // set globals
  g_dateStart = dateStart;
  g_dateEnd = dateEnd;

  // check for dates
  if( g_dateStart == "" || g_dateEnd == "" )
    return false;
  if( g_dateStart == null || g_dateEnd == null )
    return false;
  
  // build url
  var url = g_root_path;
  url += "calc_resorts.php";
  url += "?ds=" + g_dateStart;
  url += "&de=" + g_dateEnd;
  
  // run php file
  run_php( url );
    
  // success
  return true;
}


function calcResortCost( dateStart, dateEnd, pointCost, callBack )
{
  // set globals
  g_dateStart = dateStart;
  g_dateEnd = dateEnd;

  // check for dates
  if( g_dateStart == "" || g_dateEnd == "" )
    return false;
  if( g_dateStart == null || g_dateEnd == null )
    return false;
  
  // check for points
  if( pointCost == "" )
    return calcResorts();
  
  // build url
  var url = g_root_path;
  url += "calc_resorts.php";
  url += "?ds=" + g_dateStart;
  url += "&de=" + g_dateEnd;
  url += "&pc=" + pointCost;
  url += "&cu=" + callBack;
   
  // run php file
  run_php( url );
    
  // success
  return true;
}


function calcPoints( dateStart, dateEnd )
{
  // set globals
  g_dateStart = dateStart;
  g_dateEnd = dateEnd;
  
  // check for dates
  if( g_dateStart == "" || g_dateEnd == "" )
    return false;
  if( g_dateStart == null || g_dateEnd == null )
    return false;

  // get element variables
  var elementResort;
  var elementRoom;
  var elementView;
  var elementOthers;
  // get element values
  var resort = 0;
  var room = 0;
  var view = 0;
  var show_others = 0;
  var calc_costs = 0;

  // get elements
  try
  {
    elementResort = document.getElementById("resort");
  }
  catch(e)
  {
    return false;
  }
  
  // get elements
  try
  {
    elementRoom = document.getElementById("room");
    elementView = document.getElementById("view");
    elementOthers = document.getElementById("show_others");
  }
  catch(e)
  {
    return false;
  }

  // get element values
  try
  {
    resort = elementResort.options[elementResort.selectedIndex].value;
    room = elementRoom.options[elementRoom.selectedIndex].value;
    view = elementView.options[elementView.selectedIndex].value;
  }
  catch(e)
  {
    return false;
  }
  
  // get other variables
  try
  {
    calc_costs = document.getElementById("costs").value;
  }
  catch(e)
  {
  }

  // show others
  if( elementOthers )
  {
    if( elementOthers.checked == true )
      show_others = 1;
  }

  // store current
  g_resort = resort;
  g_room = room;
  g_view = view;

  // set information
  document.getElementById('points').value="calculating...";
  
  // build url
  var url;
  url = "calc_points.php";
  url += "?resort=" + g_resort;
  url += "&room=" + g_room;
  url += "&view=" + g_view;
  url += "&ds=" + g_dateStart;
  url += "&de=" + g_dateEnd;
  url += "&so=" + show_others;
  url += "&ca=" + calc_costs;
  
  // run php file
  run_php( url );
  
  // success
  return true;
}


function addTrip( dateStart, dateEnd, points, resort, room, view )
{
  var answer = confirm( "Add the trip to your planner?" )
  if( !answer )
    return false;

  // set globals
  g_dateStart = dateStart;
  g_dateEnd = dateEnd;

  // check for dates
  if( g_dateStart == "" || g_dateEnd == "" )
    return false;
  if( g_dateStart == null || g_dateEnd == null )
    return false;

  // store current
  g_resort = resort;
  g_room = room;
  g_view = view;

  // build url
  var url = g_root_path;
  url += "add_trip.php";
  url += "?points=" + points;
  url += "&resort=" + g_resort;
  url += "&room=" + g_room;
  url += "&view=" + g_view;
  url += "&ds=" + g_dateStart;
  url += "&de=" + g_dateEnd;
  
  // run php file
  run_php( url );
}


function run_php( php_url )
{
  // create new script element, set its relative URL, and load it
  script = document.createElement( 'script' );
  script.src = php_url;
  document.getElementsByTagName( 'head' )[0].appendChild( script );
}


function addYearPoints()
{
  var table = document.getElementById("YearTable");

  // add a row
  var rowCount = table.rows.length;
  var row = table.insertRow(rowCount);

  // add row cell
  var cell0 = row.insertCell(0);
  // add title box
  var element0 = document.createElement("input");
  element0.type = "text";
  element0.name = "points_year[]";
  // remove style, most compatable
  element0.removeAttribute("style");
  element0.style.cssText = "width:150px;";
  // append element
  cell0.appendChild(element0);

  // add row cell
  var cell1 = row.insertCell(1);
  // add quantity box
  var elementSelect = document.createElement("select");
  elementSelect.name = "point_month[]";

  var arrMonth = new Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
  for( var index=0; index < arrMonth.length; index++ )
  {
    //alert( arrMonth[index] );
    elementOption = document.createElement("option");
    elementOption.value = index + 1;
    elementOption.appendChild( document.createTextNode( arrMonth[index] ));
    elementSelect.appendChild( elementOption );
  }
  // remove style, most compatable
  elementSelect.removeAttribute("style");
  elementSelect.style.cssText = "width:150px;";
  // append element
  cell1.appendChild( elementSelect );

   // add row cell
  var cell2 = row.insertCell(2);
  var year = new Date().getFullYear();
  // add title box
  var element2 = document.createElement("input");
  element2.type = "text";
  element2.name = "year_start[]";
  element2.value = year;
  // remove style, most compatable
  element2.removeAttribute("style");
  element2.style.cssText = "width:150px;";
  // append element
  cell2.appendChild(element2);

   // add row cell
  var cell3 = row.insertCell(3);
  // add title box
  var element3 = document.createElement("input");
  element3.type = "text";
  element3.name = "use_year_id[]";
  element3.value = -1;
  // remove style, most compatable
  element3.removeAttribute("style");
  element3.style.cssText = "width:150px;";
  element3.setAttribute("type", "hidden");
  // append element
  cell3.appendChild(element3);

  // set focus
  element0.focus();
}


function inc1(src, afc)
{
	var nSrc = parseInt(document.getElementById(src).value);
	var nAfc = parseInt(document.getElementById(afc).value);
	document.getElementById(src).value = nSrc + 1;
	document.getElementById(afc).value = nAfc - 1;
}


function dec1(src, afc)
{
	var nSrc = parseInt(document.getElementById(src).value);
	var nAfc = parseInt(document.getElementById(afc).value);
	document.getElementById(src).value = nSrc - 1;
	document.getElementById(afc).value = nAfc + 1;
}


function inc(src, afc, val)
{
	var nVal = parseInt(document.getElementById(val).value);
	var nSrc = parseInt(document.getElementById(src).value);
	var nAfc = parseInt(document.getElementById(afc).value);
	document.getElementById(src).value = nSrc + nVal;
	document.getElementById(afc).value = nAfc - nVal;
}


function dec(src, afc, val)
{
	var nVal = parseInt(document.getElementById(val).value);
	var nSrc = parseInt(document.getElementById(src).value);
	var nAfc = parseInt(document.getElementById(afc).value);
	document.getElementById(src).value = nSrc - nVal;
	document.getElementById(afc).value = nAfc + nVal;
}


function incAll(src, afc)
{
	var nSrc = parseInt(document.getElementById(src).value);
	var nAfc = parseInt(document.getElementById(afc).value);
	document.getElementById(src).value = nSrc + nSrc;
	document.getElementById(afc).value = nAfc - nSrc;
}


function decAll(src, afc)
{
	var nSrc = parseInt(document.getElementById(src).value);
	var nAfc = parseInt(document.getElementById(afc).value);
	document.getElementById(src).value = nSrc - nSrc;
	document.getElementById(afc).value = nAfc + nSrc;
}


function fillRoomView( resort, room, view )
{
  // get current slection
  try
  {
    var elementResort = document.getElementById("resort");
    var selectedResort = elementResort.selectedIndex;
  }
  catch(e)
  {
    return;
  }

  // no selection
  if( selectedResort == 0 )
  {
    try
    {
      document.getElementById('points').value="Select resort";
    }
    catch(e)
    {
    }
    return;
  }

  // set resort
  g_resort = resort;
  // check values
  if( room > 0 ) g_room = room;
  if( view > 0 ) g_view = view;
  
  // build url
  var url;
  url = "calc_rooms.php";
  url += "?resort=" + resort;
  url += "&room=" + g_room;
  url += "&view=" + g_view;
  
  // run php file
  run_php( url );
}


function doCallback( url, open )
{
  var points = 0;
  var resort = 0;
  var room = 0;
  var view = 0;
  
  // get elements
  try
  {
    points = document.getElementById('points').value;
    resort = document.getElementById("resort").value;
    room = document.getElementById("room").value;
    view = document.getElementById("view").value;
    g_dateStart = document.getElementById("date_start").value;
    g_dateEnd = document.getElementById("date_end").value;
  }
  catch(e)
  {
    return false;
  }

  if( open == 0 )
  {
    // add points
    url += points;  
    // navigate window
    window.location.href = url;
  }
  else if( open == 1 )
  {
    // add variables
    url += "?points=" + points;
    url += "&resort=" + resort;
    url += "&room=" + room;
    url += "&view=" + view;
    url += "&ds=" + g_dateStart;
    url += "&de=" + g_dateEnd;
    // open window
    window.open( url );
  }
  else if( open == 2 )
  {
    var url_run;
    url_run = "calc_post.php";

    // add variables
    url_run += "?points=" + points;
    url_run += "&resort=2";// + resort;
    url_run += "&room=3";// + room;
    url_run += "&view=2";// + view;
    //url_run += "&ds=" + g_dateStart;
    //url_run += "&de=" + g_dateEnd;
    //url_run += "&url=test";// + url;

    //alert(url_run);

    url_run = "calc_post.php";
    //url_run += "?url=test";// + url;
    url_run += "?resort=" + 2;
    url_run += "&room=" + 3;
    url_run += "&view=" + 2;
    url_run += "&url=test";// + url;

    //alert(url_run);

    // run php file
    run_php( url_run );
  }
}

-->
</script>